class MineralVein expands Containers;

function Destroyed()
{
	local actor dropped;
	local class<actor> tempClass;
	local int i;
	local Rotator rot;
	local Vector loc;

	if( (Pawn(Base) != None) && (Pawn(Base).CarriedDecoration == self) )
		Pawn(Base).DropDecoration();
	if( (Contents!=None) && !Level.bStartup )
	{
		tempClass = Contents;
		if (Contents!=None && FRand()>0.6) tempClass = Contents;
                                                   numThings = 3;
		if (Content2!=None && FRand()>0.2) tempClass = Content2;
                                                   numThings = 2;
		if (Content3!=None && FRand()<0.2) tempClass = Content3;
                                                   numThings = 1;

		for (i=0; i<numThings; i++)
		{
			loc = Location+VRand()*CollisionRadius;
			loc.Z = Location.Z;
			rot = rot(0,0,0);
			rot.Yaw = FRand() * 65535;
			dropped = Spawn(tempClass,,, loc, rot);
			if (dropped != None)
			{
				dropped.RemoteRole = ROLE_DumbProxy;
				dropped.SetPhysics(PHYS_Falling);
				dropped.bCollideWorld = true;
				dropped.Velocity = VRand() * 50;
				if ( inventory(dropped) != None )
					inventory(dropped).GotoState('Pickup', 'Dropped');
			}
		}
	}

	Super.Destroyed();
}

#exec MESH IMPORT MESH=MineralVein ANIVFILE=C:\DeusEx\MODELS\MineralVein_a.3d DATAFILE=C:\DeusEx\MODELS\MineralVein_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MineralVein X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=MineralVein SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MineralVein SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=MineralVein MESH=MineralVein
#exec MESHMAP SCALE MESHMAP=MineralVein X=3 Y=3 Z=3

//    Style=STY_Translucent

defaultproperties
{
     numThings=3
     FragType=Class'DeusEx.Rockchip'
     ItemName="Mineral Vein"
     bPushable=False
     contents=Class'Markistan.Ore'
     content2=Class'Markistan.Ore'
     content3=Class'Markistan.Dingleberrium'
     Skin=Texture'Markistan.Skins.OreTex1'
     Mesh=LodMesh'Markistan.MineralVein'
     CollisionRadius=19.500000
     CollisionHeight=15.000000
     Physics=PHYS_NONE
     bFlammable=False
}
